-------------------------------------------------------------------------------
--   
--  File:		rc2mxs.ms		
--  Description:	Helper struct for generating Maxscript rollouts/dialogs from rc files
--  By:		Ravi Karra [Discreet] 			ravi.karra@discreet.com
--	
-- Version:		1.01
-- Note:		DO NOT LOCALIZE
-------------------------------------------------------------------------------


struct s_rc2mxs 
(
	fltStr, rW, rH, rc, fac, fc=1.5,
	fn dimStr i =
	(
		" pos:[" + fltStr[i] + fac + "," + fltStr[i+1] + fac + "] width:(" + fltStr[i+2] + fac + ") height:(" + fltStr[i+3] + fac + ") "
	),
 	fn isContinuation str =
	(
		(filterString (subString str 1 19) " ").count == 0
		--str[str.count] == ","
	),
	-- fills up "rc", an instance of rolloutCreator
	fn convertRC filename dlgID rTitle:"" = 
	(
		local ln, lbl_count = 0
		fac = "*" + fc as string
		f = openFile filename mode:"r"
		if f != undefined then
		(
			while not (eof f) do
			(
				ln = readLine f
				if (subString ln 1 3) != "IDD" then continue
				
				-- read the dialog properties
				fltStr = filterString ln " ,"
				if fltStr[1] != dlgID then continue
				rc = rolloutCreator fltStr[1] rTitle quote:""
				rc.begin()
					rW =  fltStr[fltStr.count - 1] as integer
					rH = fltStr[fltStr.count] as integer					
					
					-- skip till after BEGIN
					skipToString f "BEGIN"; readLine f
					local str = ""; ln = readLine f; type	
					while true do
					(
						str = readLine f						
						if isContinuation str then
						(
							ln += str					
						)
						else
						(
							--format "ln:%\n" ln
							fltStr = filterString ln " "
							type = fltStr[1]			
							fltStr = filterString (subString ln (findString ln fltStr[2]) ln.count) ","
							
							case type of
							(
								"LTEXT":
								(
									format "ln:%\n" ln
									lbl_count += 1
									rc.addControl #label ("label" + lbl_count as string) fltStr[1] paramStr:(dimStr 3)
								)
								"EDITTEXT":
								(
									rc.addControl #editText fltStr[1] "" paramStr:(dimStr 2)
								)
								"PUSHBUTTON":
								(
									rc.addControl #button fltStr[2] fltStr[1] paramStr:(dimStr 3)
								)
								"LISTBOX":
								(
									local h = ceil (((fltStr[5] as float)*fc)/(gettextextent "T")[2]) as string
									rc.addControl #listbox fltStr[1] "" paramStr:("height:" + h + dimStr 2)
								)
							)							
							if str == "END" then 
							(
								close f
								rc.end()
								return true
							)
							ln = str							
						)						
					)														
			)
			close f
			false
		)
	)
)

rc2mxs = s_rc2mxs()
--rc2mxs.convertRC "F:/devel/3dswin/src/maxsdk/Samples/SdkApWz/SdkApWz.rc" "IDD_CUSTOM2"
--rc2mxs.convertRC "D:/devel/3dswin/src/app/3dswin.rc" "IDD_ABOUT"
--createDialog rc2mxs.rc.def width:(rc2mxs.rW*rc2mxs.fc) height:(rc2mxs.rH*rc2mxs.fc)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB170apZV410q7M4qIHk/uNQ9EY5La7jjBz
-- icT43FR7wbDWWVb3Vro3X/DKndokGgAVMTI9qD+hcalswjWhsqAjVTKhHKYtZVbY
-- I2w3ehcoc9Ti+1cCM1JHNtl6lTjPNUAS8/TvhMVX5uTRM45nxYmcN2NXi7jZkHZC
-- sibY8i+2z4Rvu6UQRmNErUWBkfSkQLvNN2tjnWchJ1AuT9ChlD9iFPBhq/VLB/6S
-- r1Vm+aK9lQ1PcRfcBVaaTj0SgbprsnGKYY1ZyTiwWEKnleSJx3MGcETXSXuveV7s
-- Z1pHlMbGCZh6ES05sJlfjrr/tMtT/cXeeSiK4YYZM7BzJ7g4t9CY
-- -----END-SIGNATURE-----